<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BloquePelicula extends Model 
{

    protected $table = 'bloques_peliculas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('bloques_id', 'pelicula_id');
    protected $visible = array('bloques_id', 'pelicula_id');

    public function bloque()
    {
        return $this->belongsTo('Bloque', 'bloque_id')->withTrashed();
    }

    public function pelicula()
    {
        return $this->belongsTo('Pelicula', 'pelicula_id')->withTrashed();
    }

}